/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Id: HostInformation.cpp 2218 2010-10-25 10:09:15Z stephans $
   Last Modification:
    $Author: stephans $
    $Date: 2010-10-25 12:09:15 +0200 (Mo, 25 Okt 2010) $
    $Revision: 2218 $

   Targets:
     Win32        : yes

   Description:
    Host Information Dialog

   Changes:

     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
     1        16.07.2010   SS       initial version

**************************************************************************************/


#include "stdafx.h"
#include "cifXTCPServer.h"
#include "HostInformation.h"
#include "cifXUser.h"
#include "cifXErrors.h"
#include "TCPConnector.h"

// HostInformation dialog

IMPLEMENT_DYNAMIC(HostInformation, CDialog)
HostInformation::HostInformation(CWnd* pParent /*=NULL*/)
	: CDialog(HostInformation::IDD, pParent)
{
}

HostInformation::~HostInformation()
{
}

void HostInformation::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  DDX_Control(pDX, IDC_DEVICETREE, m_cTreeCtrl);
}

/*****************************************************************************/
/*! This function is called in response to the WM_INITDIALOG message.        */
/*****************************************************************************/
BOOL HostInformation::OnInitDialog()
{
  CDialog::OnInitDialog();

  uint32_t ulBoardIdx = 0;
  int32_t  lBoardRet  = CIFX_NO_ERROR;
  char     szIPAddress[15];

  if (TLR_S_OK == TCPConnectorGetLocalIP(szIPAddress, sizeof(szIPAddress)))
  {
    CString csIPAddress = CString(_T("Local IP Address: ")) + CString(szIPAddress);
    SetDlgItemText(IDC_IPADDRESS, csIPAddress);
  }

  while(lBoardRet == CIFX_NO_ERROR)
  {
    // Enumerate the boards
    BOARD_INFORMATION tBoardInfo = {0};
    if(CIFX_NO_ERROR == (lBoardRet = xDriverEnumBoards(NULL, ulBoardIdx, sizeof(tBoardInfo), &tBoardInfo)))
    {
      CString   csTmp;
      HTREEITEM hDevice = m_cTreeCtrl.InsertItem(CString(tBoardInfo.abBoardName));
      
      csTmp = CString(_T("Alias: ")) + CString(tBoardInfo.abBoardAlias);
      m_cTreeCtrl.InsertItem(csTmp, hDevice);
      csTmp.Format(_T("Device Number: %d"), tBoardInfo.tSystemInfo.ulDeviceNumber);
      m_cTreeCtrl.InsertItem(csTmp, hDevice);
      csTmp.Format(_T("Serial Number: %d"), tBoardInfo.tSystemInfo.ulSerialNumber);
      m_cTreeCtrl.InsertItem(csTmp, hDevice);
      csTmp.Format(_T("Channels: %d"), tBoardInfo.ulChannelCnt);
      m_cTreeCtrl.InsertItem(csTmp, hDevice);
      csTmp.Format(_T("DPM Size: %d"), tBoardInfo.ulDpmTotalSize);
      m_cTreeCtrl.InsertItem(csTmp, hDevice);
      m_cTreeCtrl.Expand(hDevice, TVE_EXPAND);
      ++ulBoardIdx;
    }
  }
  return TRUE;
}


BEGIN_MESSAGE_MAP(HostInformation, CDialog)
END_MESSAGE_MAP()


// HostInformation message handlers
